/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.ConfigLoader;
import com.tmtravlr.potioncore.PotionCore;
import com.tmtravlr.potioncore.PotionCoreAttributes;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.PotionCorePlayerController;
import com.tmtravlr.potioncore.potion.PotionDrown;
import com.tmtravlr.potioncore.potion.PotionPerplexity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameType;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="potioncore")
public class PotionCoreEventHandlerClient {
    private static final Minecraft MC = Minecraft.func_71410_x();
    public static boolean inverted = false;
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");
    private static final ResourceLocation ARMOR_OVERLAYS = new ResourceLocation("potioncore", "textures/gui/armor_overlays.png");
    private static final ResourceLocation ARMOR_MAGIC_SHIELD = new ResourceLocation("potioncore", "textures/gui/armor_magic_shield.png");

    @SubscribeEvent
    public static void renderOverlaysPre(RenderGameOverlayEvent.Pre event) {
        int top;
        int left;
        EntityLivingBase player;
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && (player = (EntityLivingBase)MC.func_175606_aa()) != null && PotionDrown.INSTANCE.isEnabled() && player.func_70644_a((Potion)PotionDrown.INSTANCE)) {
            event.setCanceled(true);
            if (!player.func_70055_a(Material.field_151586_h)) {
                int air = player.getEntityData().func_74762_e("potioncore - drown air");
                PotionCoreEventHandlerClient.MC.field_71424_I.func_76320_a("air");
                GlStateManager.func_179147_l();
                int width = event.getResolution().func_78326_a();
                int height = event.getResolution().func_78328_b();
                left = width / 2 + 91;
                top = height - GuiIngameForge.right_height;
                int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
                int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
                for (int i = 0; i < full + partial; ++i) {
                    PotionCoreEventHandlerClient.MC.field_71456_v.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                }
                GuiIngameForge.right_height += 10;
                GlStateManager.func_179084_k();
                PotionCoreEventHandlerClient.MC.field_71424_I.func_76319_b();
            }
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR && ConfigLoader.renderArmorOverlay) {
            player = (EntityLivingBase)MC.func_175606_aa();
            PotionCoreEventHandlerClient.MC.field_71424_I.func_76320_a("armor");
            GlStateManager.func_179147_l();
            ScaledResolution scale = event.getResolution();
            double z = -90.0;
            left = scale.func_78326_a() / 2 - 91;
            top = scale.func_78328_b() - GuiIngameForge.left_height;
            double resistance = (player.func_110148_a(PotionCoreAttributes.DAMAGE_RESISTANCE).func_111126_e() - 1.0) * 20.0;
            int currentLeft = left;
            MC.func_110434_K().func_110577_a(ARMOR_OVERLAYS);
            for (int i = 2; resistance > 0.0 && i <= 20; i += 2) {
                if ((double)i <= resistance) {
                    PotionCoreEventHandlerClient.drawArmorOverlayRectangle(currentLeft - 1, top - 1, z - 10.0, 27.0, 0.0, 11.0, 11.0);
                } else if ((double)i > resistance && resistance >= (double)(i - 2)) {
                    int partial = MathHelper.func_76128_c((double)(resistance % 2.0 * 11.0 / 2.0));
                    PotionCoreEventHandlerClient.drawArmorOverlayRectangle(currentLeft - 1, top - 1, z - 10.0, 27.0, 0.0, partial, 11.0);
                }
                currentLeft += 8;
            }
            GlStateManager.func_179084_k();
            MC.func_110434_K().func_110577_a(GuiIngameForge.field_110324_m);
            PotionCoreEventHandlerClient.MC.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public static void renderOverlaysPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR && ConfigLoader.renderArmorOverlay) {
            int i;
            PotionCoreEventHandlerClient.MC.field_71424_I.func_76320_a("armor");
            GlStateManager.func_179147_l();
            ScaledResolution scale = event.getResolution();
            double z = -90.0;
            int left = scale.func_78326_a() / 2 - 91;
            int top = scale.func_78328_b() - GuiIngameForge.left_height + 10;
            boolean renderBase = false;
            double magicShield = PotionCoreEventHandlerClient.MC.field_71439_g.func_110148_a(PotionCoreAttributes.MAGIC_SHIELDING).func_111126_e();
            double resistance = (PotionCoreEventHandlerClient.MC.field_71439_g.func_110148_a(PotionCoreAttributes.DAMAGE_RESISTANCE).func_111126_e() - 1.0) * 20.0;
            double armorToughness = PotionCoreEventHandlerClient.MC.field_71439_g.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e();
            double armor = ForgeHooks.getTotalArmorValue((EntityPlayer)PotionCoreEventHandlerClient.MC.field_71439_g);
            if (magicShield > 0.0 || resistance > 0.0 || armor > 0.0 || armorToughness > 0.0) {
                renderBase = true;
            }
            if (renderBase && armor == 0.0) {
                MC.func_110434_K().func_110577_a(Gui.field_110324_m);
                for (int i2 = 0; i2 < 10; ++i2) {
                    PotionCoreEventHandlerClient.MC.field_71456_v.func_73729_b(left + i2 * 8, top, 16, 9, 9, 9);
                }
            }
            int currentLeft = left;
            MC.func_110434_K().func_110577_a(ARMOR_OVERLAYS);
            for (i = 21; renderBase && i < 40; i += 2) {
                if ((double)i < armor) {
                    PotionCoreEventHandlerClient.drawArmorOverlayRectangle(currentLeft, top, z, 9.0, 0.0, 9.0, 9.0);
                } else if ((double)i == armor) {
                    PotionCoreEventHandlerClient.drawArmorOverlayRectangle(currentLeft, top, z, 0.0, 0.0, 9.0, 9.0);
                }
                currentLeft += 8;
            }
            currentLeft = left;
            for (i = 2; armorToughness > 0.0 && i <= 20; i += 2) {
                if ((double)i <= armorToughness) {
                    PotionCoreEventHandlerClient.drawArmorOverlayRectangle(currentLeft, top, z + 10.0, 18.0, 0.0, 9.0, 9.0);
                } else if ((double)i > armorToughness && armorToughness >= (double)(i - 2)) {
                    int partial = MathHelper.func_76128_c((double)(armorToughness % 2.0 * 9.0 / 2.0));
                    PotionCoreEventHandlerClient.drawArmorOverlayRectangle(currentLeft, top, z + 10.0, 18.0, 0.0, partial, 9.0);
                }
                currentLeft += 8;
            }
            MC.func_110434_K().func_110577_a(ARMOR_MAGIC_SHIELD);
            currentLeft = left;
            int glintWidth = Math.min(82, MathHelper.func_76128_c((double)(magicShield * 4.0 + 2.0)));
            if (glintWidth == 82) {
                glintWidth = 83;
            }
            if (glintWidth > 2) {
                PotionCoreEventHandlerClient.drawEnchantmentGlint(currentLeft - 1, top - 1, z - 30.0, glintWidth, 11.0);
            }
            GlStateManager.func_179084_k();
            MC.func_110434_K().func_110577_a(GuiIngameForge.field_110324_m);
            PotionCoreEventHandlerClient.MC.field_71424_I.func_76319_b();
        }
    }

    private static void drawArmorOverlayRectangle(double x, double y, double z, double uStart, double vStart, double width, double height) {
        double uEnd = uStart + width;
        double vEnd = vStart + height;
        double uMult = 0.015625;
        double vMult = 0.03125;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(x, y + height, z).func_187315_a(uStart * uMult, vEnd * vMult).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, z).func_187315_a(uEnd * uMult, vEnd * vMult).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y, z).func_187315_a(uEnd * uMult, vStart * vMult).func_181675_d();
        vertexBuffer.func_181662_b(x, y, z).func_187315_a(uStart * uMult, vStart * vMult).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void drawEnchantmentGlint(double x, double y, double z, double width, double height) {
        float scale = 8.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)516);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179124_c((float)0.95f, (float)0.75f, (float)0.95f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        PotionCoreEventHandlerClient.drawGlintRectangle(x, y, z, width, height);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        PotionCoreEventHandlerClient.drawGlintRectangle(x, y, z, width, height);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
    }

    private static void drawGlintRectangle(double x, double y, double z, double width, double height) {
        double uWidth = width / 80.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(x, y + height, z).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, z).func_187315_a(uWidth, 1.0).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y, z).func_187315_a(uWidth, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private static int getSpecialArmorDisplay(EntityPlayer player) {
        int ret = 0;
        for (int x = 0; x < player.field_71071_by.field_70460_b.size(); ++x) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(x);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISpecialArmor)) continue;
            ret += ((ISpecialArmor)stack.func_77973_b()).getArmorDisplay(player, stack, x);
        }
        return ret;
    }

    @SubscribeEvent
    public static void onFogRender(EntityViewRenderEvent.FogDensity event) {
        if (ConfigLoader.fixBlindness && event.getEntity() == PotionCoreEventHandlerClient.MC.field_71439_g && PotionCoreEventHandlerClient.MC.field_71439_g.func_70644_a(MobEffects.field_76440_q)) {
            float f1 = 5.0f;
            int duration = PotionCoreEventHandlerClient.MC.field_71439_g.func_70660_b(MobEffects.field_76440_q).func_76459_b();
            int amplifier = PotionCoreEventHandlerClient.MC.field_71439_g.func_70660_b(MobEffects.field_76440_q).func_76458_c() + 1;
            if (duration < 20) {
                f1 = 5.0f + ((float)(PotionCoreEventHandlerClient.MC.field_71474_y.field_151451_c * 16) - 5.0f) * (1.0f - (float)duration / 20.0f);
            }
            float multiplier = 0.25f / (float)amplifier;
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            GlStateManager.func_179102_b((float)(f1 * multiplier));
            GlStateManager.func_179153_c((float)(f1 * multiplier * 4.0f));
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi((int)34138, (int)34139);
            }
            event.setDensity(2.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientConnectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        PotionCoreHelper.hasServer = false;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = PotionCoreEventHandlerClient.MC.field_71439_g;
        NBTTagCompound persisted = new NBTTagCompound();
        if (ConfigLoader.fixReach && player != null && PotionCoreEventHandlerClient.MC.field_71442_b != null && !(PotionCoreEventHandlerClient.MC.field_71442_b instanceof PotionCorePlayerController)) {
            NetHandlerPlayClient netHandler = (NetHandlerPlayClient)ObfuscationReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)PotionCoreEventHandlerClient.MC.field_71442_b, (String[])new String[]{"netClientHandler", "field_78774_b"});
            GameType gameType = PotionCoreEventHandlerClient.MC.field_71442_b.func_178889_l();
            PotionCoreEventHandlerClient.MC.field_71442_b = new PotionCorePlayerController(MC, netHandler);
            PotionCoreEventHandlerClient.MC.field_71442_b.func_78746_a(gameType);
        }
        if (player != null) {
            persisted = player.getEntityData().func_74775_l("PlayerPersisted");
            if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persisted);
            }
        }
        if (PotionCoreEventHandlerClient.MC.field_71441_e != null && player != null && PotionPerplexity.INSTANCE.isEnabled() && player.func_70644_a((Potion)PotionPerplexity.INSTANCE)) {
            if (!inverted) {
                PotionCoreEventHandlerClient.saveInverted(true);
            }
        } else if (inverted) {
            PotionCoreEventHandlerClient.saveInverted(false);
        }
    }

    private static void saveInverted(boolean toSave) {
        inverted = toSave;
        try {
            File options = (File)ObfuscationReflectionHelper.getPrivateValue(GameSettings.class, (Object)Minecraft.func_71410_x().field_71474_y, (String[])new String[]{"optionsFile", "field_74354_ai"});
            if (!options.exists()) {
                return;
            }
            PrintWriter printwriter = new PrintWriter(new FileWriter(options));
            printwriter.println("inverted:" + inverted);
            printwriter.close();
        }
        catch (Exception e) {
            PotionCore.logger.warn("Failed to save options", (Throwable)e);
        }
        KeyBinding temp = PotionCoreEventHandlerClient.MC.field_71474_y.field_74351_w;
        PotionCoreEventHandlerClient.MC.field_71474_y.field_74351_w = PotionCoreEventHandlerClient.MC.field_71474_y.field_74368_y;
        PotionCoreEventHandlerClient.MC.field_71474_y.field_74368_y = temp;
        temp = PotionCoreEventHandlerClient.MC.field_71474_y.field_74370_x;
        PotionCoreEventHandlerClient.MC.field_71474_y.field_74370_x = PotionCoreEventHandlerClient.MC.field_71474_y.field_74366_z;
        PotionCoreEventHandlerClient.MC.field_71474_y.field_74366_z = temp;
        temp = PotionCoreEventHandlerClient.MC.field_71474_y.field_74311_E;
        PotionCoreEventHandlerClient.MC.field_71474_y.field_74311_E = PotionCoreEventHandlerClient.MC.field_71474_y.field_74314_A;
        PotionCoreEventHandlerClient.MC.field_71474_y.field_74314_A = temp;
        PotionCoreEventHandlerClient.MC.field_71474_y.field_74338_d = !PotionCoreEventHandlerClient.MC.field_71474_y.field_74338_d;
        PotionCoreEventHandlerClient.MC.field_71474_y.func_74303_b();
    }

    public static void loadInverted() {
        File options = (File)ObfuscationReflectionHelper.getPrivateValue(GameSettings.class, (Object)Minecraft.func_71410_x().field_71474_y, (String[])new String[]{"optionsFile", "field_74354_ai"});
        if (!options.exists()) {
            return;
        }
        try {
            BufferedReader bufferedreader = new BufferedReader(new FileReader(options));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                try {
                    String[] astring = s.split(":");
                    if (!astring[0].equals("inverted")) continue;
                    inverted = Boolean.valueOf(astring[1]);
                }
                catch (Exception var8) {
                    PotionCore.logger.warn("Skipping bad option: " + s);
                }
            }
            bufferedreader.close();
        }
        catch (Exception e) {
            PotionCore.logger.error("Failed to load options", (Throwable)e);
        }
    }
}

